/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MKaisyaDto;

public class MKaisyaDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  	= "M_KAISYA";
	public static final String KEY_1 		= "ID";			//ƏR[h

	// 
	public static final String COL_ID 			= "ID";			//ƏR[h
	public static final String COL_KAIMEI  		= "KAIMEI";		//Ж
	public static final String COL_KAIFURI 	 	= "KAIFURI";	//ӂ肪
	public static final String COL_KJIGYONUSI  	= "KJIGYONUSI";	//Ǝ
	public static final String COL_KAIYUBIN  		= "KAIYUBIN";	//X֔ԍ
	public static final String COL_KAIJYUSYO  	= "KAIJYUSYO";	//Z
	public static final String COL_KAITEL  		= "KAITEL";		//dbԍ
	public static final String COL_KAIFAX  		= "KAIFAX";		//t@bNXԍ
	public static final String COL_RODOUBI  		= "RODOUBI";	//ԏJ
	public static final String COL_ROUDOUJI  		= "ROUDOUJI";	//ԏJԐ
	public static final String COL_ROUDOUJI1  	= "ROUDOUJI1";	//JԐ
	public static final String COL_ZARITU  		= "ZARITU";		//ʎcƊ
	public static final String COL_KSRITU  		= "KSRITU";		//xcƊ
	public static final String COL_SNRITU 		= "SNRITU";		//[cƊ
	public static final String COL_ZANTANKBN  	= "ZANTANKBN";	//cƒPvZ
	public static final String COL_RITKOYOU  		= "RITKOYOU";	//ٗpی
	public static final String COL_RITKKOYOU  	= "RITKKOYOU";	//ٗpی
	public static final String COL_RITKENPO  		= "RITKENPO";	//Nی
	public static final String COL_RITKKENPO  	= "RITKKENPO";	//Nی
	public static final String COL_RITKAIGO  		= "RITKAIGO";	//ی
	public static final String COL_RITKKAIGO  	= "RITKKAIGO";	//ی
	public static final String COL_RITKOSEI  		= "RITKOSEI";	//N
	public static final String COL_RITKKOSEI  	= "RITKKOSEI";	//N
	public static final String COL_RITKOSEI3  	= "RITKOSEI3";	//NO헿
	public static final String COL_RITKKOSEI3  	= "RITKKOSEI3";	//NO헿
	public static final String COL_KOSEI3KBN  	= "KOSEI3KBN";	//NO
	public static final String COL_KIKINKBN  		= "KIKINKBN";	//N
	public static final String COL_RITKIKIN  		= "RITKIKIN";	//N
	public static final String COL_RITKKIKIN  	= "RITKKIKIN";	//N
	public static final String COL_RITKIKIN3  	= "RITKIKIN3";	//NO헿
	public static final String COL_RITKKIKIN3  	= "RITKKIKIN3";	//NO헿
	public static final String COL_SYAHOFUGO  	= "SYAHOFUGO";	//Ss敄
	public static final String COL_SYAHOKIGO  	= "SYAHOKIGO";	//ƏL
	public static final String COL_SYAHOBANGO  	= "SYAHOBANGO";	//Ə
	public static final String COL_KENPOJINO  	= "KENPOJINO";	//NیƏԍ
	public static final String COL_KIKINJINO  	= "KIKINJINO";	//NƏԍ
	public static final String COL_KAIBANK  		= "KAIBANK";	//s
	public static final String COL_SERVER  		= "SERVER";		//T[o[

	/**
	 * RXgN^
	 */
	public MKaisyaDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MKaisyaDto> mappingAll() throws SQLException {
		List<MKaisyaDto> all = new ArrayList<MKaisyaDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kaisyaDto m_kaisyaR[h
	 * @throws SQLException
	 */
	private MKaisyaDto mapping() throws SQLException {
		MKaisyaDto dto = new MKaisyaDto();
		dto.setId 			(rs.getString (COL_ID			));		//ƏR[h
		dto.setKaiMei 		(rs.getString (COL_KAIMEI		));		//Ж
		dto.setKaiFuri 		(rs.getString (COL_KAIFURI		));		//ӂ肪
		dto.setKJigyoNusi 	(rs.getString (COL_KJIGYONUSI	));		//Ǝ
		dto.setKaiYubin 	(rs.getString (COL_KAIYUBIN		));		//X֔ԍ
		dto.setKaiJyusyo 	(rs.getString (COL_KAIJYUSYO 	));		//Z
		dto.setKaiTel 		(rs.getString (COL_KAITEL		));		//dbԍ
		dto.setKaiFax 		(rs.getString (COL_KAIFAX		));		//t@bNXԍ
		dto.setRodouBi 		(rs.getInt    (COL_RODOUBI		));		//ԏJ
		dto.setRoudouJi 	(rs.getInt    (COL_ROUDOUJI		));		//ԏJԐ
		dto.setRoudouJi1 	(rs.getInt    (COL_ROUDOUJI1	));		//JԐ
		dto.setZaRitu 		(rs.getInt    (COL_ZARITU		));		//ʎcƊ
		dto.setKsRitu 		(rs.getInt    (COL_KSRITU		));		//xcƊ
		dto.setSnRitu 		(rs.getInt    (COL_SNRITU		));		//[cƊ
		dto.setZanTanKbn 	(rs.getString (COL_ZANTANKBN	));		//cƒPvZ
		dto.setRitKoyou 	(rs.getDouble (COL_RITKOYOU		));		//ٗpی
		dto.setRitKKoyou 	(rs.getDouble (COL_RITKKOYOU	));		//ٗpی
		dto.setRitKenpo 	(rs.getDouble (COL_RITKENPO		));		//Nی
		dto.setRitKKenpo 	(rs.getDouble (COL_RITKKENPO	));		//Nی
		dto.setRitKaigo 	(rs.getDouble (COL_RITKAIGO		));		//ی
		dto.setRitKKaigo 	(rs.getDouble (COL_RITKKAIGO	));		//ی
		dto.setRitKosei 	(rs.getDouble (COL_RITKOSEI		));		//N
		dto.setRitKKosei 	(rs.getDouble (COL_RITKKOSEI	));		//N
		dto.setRitKosei3 	(rs.getDouble (COL_RITKOSEI3	));		//NO헿
		dto.setRitKKosei3 	(rs.getDouble (COL_RITKKOSEI3	));		//NO헿
		dto.setKosei3Kbn 	(rs.getString (COL_KOSEI3KBN	));		//NO
		dto.setKikinKbn 	(rs.getString (COL_KIKINKBN		));		//N
		dto.setRitKikin 	(rs.getDouble (COL_RITKIKIN		));		//N
		dto.setRitKKikin 	(rs.getDouble (COL_RITKKIKIN	));		//N
		dto.setRitKikin3 	(rs.getDouble (COL_RITKIKIN3	));		//NO헿
		dto.setRitKKikin3 	(rs.getDouble (COL_RITKKIKIN3	));		//NO헿
		dto.setSyahoFugo 	(rs.getString (COL_SYAHOFUGO	));		//Ss敄
		dto.setSyahoKigo 	(rs.getString (COL_SYAHOKIGO	));		//ƏL
		dto.setSyahoBango 	(rs.getString (COL_SYAHOBANGO	));		//Ə
		dto.setKenpoJiNo 	(rs.getString (COL_KENPOJINO	));		//NیƏԍ
		dto.setKikinJiNo 	(rs.getString (COL_KIKINJINO	));		//NƏԍ
		dto.setKaiBank 		(rs.getString (COL_KAIBANK		));		//s
		dto.setServer 		(rs.getString (COL_SERVER		));		//T[o[

		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKaisyaDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MKaisyaDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param  id	ƏR[h(L[)
	 * @return m_kaisyaDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKaisyaDto findForKey(
			String id
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, id );
			executeQuery();
			MKaisyaDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param  id	ƏR[h(L[)
	 * @return m_kaisyaDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKaisyaDto findForUpdate(
			String id
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, id);
			executeQuery();
			MKaisyaDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param	id  ƏR[h
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKaisyaDto> findForCondition(
			String id
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_ID);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, id);
			executeQuery();
			List<MKaisyaDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param id ƏR[h
	 * @param kaimei Ə
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKaisyaDto> findForCondition(
			String id,
			String kaimei
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_ID);
		sb.append(" LIKE ? AND ");
		sb.append(COL_KAIMEI);
		sb.append(" LIKE ?  ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, id + "%");
			setParam(index++, "%" + kaimei + "%" );
			executeQuery();
			List<MKaisyaDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKaisyaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKaisyaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKaisyaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKaisyaDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getId());			//ƏR[h
		setParam(index++, dto.getKaiMei());		//Ж
		setParam(index++, dto.getKaiFuri());	//ӂ肪
		setParam(index++, dto.getKJigyoNusi());	//Ǝ
		setParam(index++, dto.getKaiYubin());	//X֔ԍ
		setParam(index++, dto.getKaiJyusyo());	//Z
		setParam(index++, dto.getKaiTel());		//dbԍ
		setParam(index++, dto.getKaiFax());		//t@bNXԍ
		setParam(index++, dto.getRodouBi());	//ԏJ
		setParam(index++, dto.getRoudouJi());	//ԏJԐ
		setParam(index++, dto.getRoudouJi1());	//JԐ
		setParam(index++, dto.getZaRitu());		//ʎcƊ
		setParam(index++, dto.getKsRitu());		//xcƊ
		setParam(index++, dto.getSnRitu());		//[cƊ
		setParam(index++, dto.getZanTanKbn());	//cƒPvZ
		setParam(index++, dto.getRitKoyou());	//ٗpی
		setParam(index++, dto.getRitKKoyou());	//ٗpی
		setParam(index++, dto.getRitKenpo());	//Nی
		setParam(index++, dto.getRitKKenpo());	//Nی
		setParam(index++, dto.getRitKaigo());	//ی
		setParam(index++, dto.getRitKKaigo());	//ی
		setParam(index++, dto.getRitKosei());	//N
		setParam(index++, dto.getRitKKosei());	//N
		setParam(index++, dto.getRitKosei3());	//NO헿
		setParam(index++, dto.getRitKKosei3());	//NO헿
		setParam(index++, dto.getKosei3Kbn());	//NO
		setParam(index++, dto.getKikinKbn());	//N
		setParam(index++, dto.getRitKikin());	//N
		setParam(index++, dto.getRitKKikin());	//N
		setParam(index++, dto.getRitKikin3());	//NO헿
		setParam(index++, dto.getRitKKikin3());	//NO헿
		setParam(index++, dto.getSyahoFugo());	//Ss敄
		setParam(index++, dto.getSyahoKigo());	//ƏL
		setParam(index++, dto.getSyahoBango());	//Ə
		setParam(index++, dto.getKenpoJiNo());	//NیƏԍ
		setParam(index++, dto.getKikinJiNo());	//NƏԍ
		setParam(index++, dto.getKaiBank());	//s
		setParam(index++, dto.getServer());		//T[o[
		setCommonParams(isInsert);
	}

}
